<?php
defined('PF_VERSION') OR exit('Access denied');
require ABSPATH . '/themes/aphrodite/options/theme_options.php';
$aphrodite_options = get_aphrodite_data();
?>
<!DOCTYPE html>
<html lang="en">
<meta charset="<?php echo get_head_info('charset'); ?>">
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo get_head_info('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo get_head_info('description'); ?>">
    <meta name="keywords" content="<?php echo get_head_info('keywords'); ?>">
    <meta name="author" content="PageFlex">
    <link rel="shortcut icon" href="<?php echo RELATIVE_PATH; ?>/themes/<?php echo $theme; ?>/img/favicon.ico">
    <link rel="canonical" href="<?php echo site_url().RELATIVE_PATH;?>" >
    <title><?php echo get_head_info('title'); ?></title>
    <!-- include css (do not remove this line) -->
    <?php
        echo get_google_fonts($aphrodite_options['google-font']);
        if($aphrodite_options['version'] != ''):
            $aphrodite_options['body-class'] = ($aphrodite_options['color'] =='theme') ? $aphrodite_options['body-class'] : 'body-custom';
            echo '<link href="'.RELATIVE_PATH.'/themes/aphrodite/options/style.php?v='.$aphrodite_options['version'].'" rel="stylesheet">';
        endif;
    ?>
    <!-- Resources -->
    <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->
    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="<?php echo RELATIVE_PATH; ?>/themes/<?php echo $theme; ?>/js/jquery-1.9.1.min.js"></script>
    <script src="<?php echo RELATIVE_PATH; ?>/themes/<?php echo $theme; ?>/js/bootstrap.js"></script>
</head>
<body class="<?php echo isset($aphrodite_options['body-class']) ? $aphrodite_options['body-class'] : 'body-green'; ?>">
    <?php if(isset($rs['page_type']) && $rs['page_type'] == 0): ?>
    <div class="top">
    </div><!-- end .top -->
    <!-- <div class="navbar navbar-inverse navbar-fixed-top" role="navigation"> -->
    <div id='nav-wrap'>
        <div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
            <div class="container">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand logo" id="logo" href="<?php echo site_url() . RELATIVE_PATH ?>">
                        <?php echo get_aphrodite_logo($aphrodite_options); ?>
                    </a>
                </div>
                <div id='navbar-collapse' class="navbar-collapse collapse">
                        <ul class="nav navbar-nav navbar-right hidden-xs">
                            <?php
                            $ref    =   "/".$_GET['pf_page_url']=='user'?'#':urlencode($_SERVER['REQUEST_URI']);
                            if(is_login()){ ?>
                            <li class="show animated flipInX" id="user-bar">
                                <a href="#" class="dropdown-toggle" id="user-dropdown">
                                    <span><?php echo current_user('user-name'); ?> <i class="caret"></i></span>
                                </a>
                                <div id="usermenu" class="hidden">
                                    <div class="user-header bg-light-blue">
                                        <?php echo user_avatar(current_user('user-id'),'90px','img-circle border-color'); ?>
                                        <p>
                                            <?php echo current_user('user-name'); ?>
                                        </p>
                                    </div>
                                    <div class="user-footer center">
                                        <div class="pull-left">
                                            <a href="<?php echo public_url("user/profile:view",false); ?>" class="btn btn-default btn-flat"><?php echo __('My Profile','aphrodite-theme'); ?></a>
                                        </div>
                                        <?php if(current_user('user-group')<5) {?><a href="<?php echo public_base_url() . "admin"; ?>"  class="btn btn-default btn-flat"><?php echo __('Admin Panel','aphrodite-theme'); ?></a><?php } ?>
                                        <div class="pull-right">
                                            <a href="<?php echo public_url("user/user-action:logout/?ref=".$ref,false); ?>" class="btn btn-default btn-flat"><?php echo __('Sign Out', 'aphrodite-theme'); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <?php } else { ?>
                            <li class="show animated flipInX" id="sign-in"><a href="<?php echo public_url("user/user-action:login/?ref=".$ref,false); ?>"><?php echo __('Sign In','aphrodite-theme'); ?></a></li>
                            <?php } ?>
                            <!-- Search Button -->
                    <?php
                    $post_list = get_configuration('page_lists', 'pf_post');
                    if (get_configuration('enable_search') == 1 && !empty($post_list)):
                        ?>
                            <li id="search">
                                <a id="search-btn" href="#"><i id="search-icon" class="fa fa-search fa-color"></i> <?php echo __('Search', 'aphrodite-theme') ?></a>
                                <div id="search-box" class="search-box hidden opacity-color">
                                    <form action="<?php echo site_url() . RELATIVE_PATH . '/' . $post_list ?>" method="GET">
                                        <div class="input-group">
                                            <input type="text" placeholder="<?php echo __('Search', 'aphrodite-theme') ?>" class="form-control" name="title">
                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-default" id="btn-search">Go!</button>
                                        </span>
                                        </div>
                                    </form>
                                </div>
                            </li>
                        <?php endif; ?>
                        </ul>
                    <?php echo Pf::shortcode()->exec("{pf:menu id=" . get_configuration('main_menu') . " type=main }"); ?>
                    <div id="search-box-xs" class="visible-xs">
                        <hr/>
                        <?php if(is_login()){ ?>
                        <p><a href="<?php echo public_url("/user/profile:view"); ?>"><?php echo current_user('user-name'); ?></a></p>
                        <?php if(current_user('user-group')<5) {?>
                        <p><a href="<?php echo public_base_url()."admin"; ?>"><i class="fa fa-laptop fa-color" id="admin-panel"></i> <?php echo __('Admin Panel','aphrodite-theme'); ?></a></p>
                        <?php } ?>
                        <p><a href="<?php echo public_url("user/profile:edit",false); ?>"><i class="fa fa-cog fa-color"></i> <?php echo __('Edit Profile','aphrodite-theme'); ?></a></p>
                        <p><a href="<?php echo public_url("user/user-action:logout/?ref=".$ref,false); ?>"><i class="fa fa-sign-out fa-color" id="sign-out"></i> <?php echo __('Logout','aphrodite-theme'); ?></a></p>
                        <?php } else { ?>
                            <li class="show animated flipInX" id="sign-in"><a href="<?php echo public_url("user/user-action:login/?ref=".$ref,false); ?>" ><?php echo __('Sign In','aphrodite-theme'); ?></a></li>
                            <li class="show animated flipInX" id="sign-up"><a href="<?php echo public_url("user/user-action:register",false) ?>" ><?php echo __('Sign Up','aphrodite-theme'); ?></a></li>
                        <?php } ?>
                    <?php
                    if (get_configuration('enable_search') == 1):
                        ?>
                        <form class="navbar-form navbar-left" role="search" action="<?php echo site_url() . RELATIVE_PATH . '/' . get_configuration('page_lists', 'pf_post') ?>" method="GET">
                            <div class="form-group">
                                <input type="text" class="form-control" placeholder="<?php echo __('Search', 'aphrodite-theme') ?>">
                            </div>
                            <button type="button" class="btn btn-default" id="btn-search-xs"><?php echo __('Go', 'aphrodite-theme') ?></button>
                        </form>
                     <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <!-- Body -->
    <div class="wrapper"> <!-- wrapper -->
        <div class="announcement-top">
                <?php echo Pf::shortcode()->exec("{pf:announcement}"); ?>
        </div>
        <?php if (!empty($widgets['panel_1']) && has_active_widget($widgets['panel_1'], $active_widgets)){ ?>
            <div class="container<?php echo $container_top = ' container_top'; ?>">
                <div class="row">
                    <div class="col-md-12">
                        <?php load_widgets((is_array($widgets['panel_1'])) ? $widgets['panel_1'] : array(), $setting_data, $active_widgets); ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        <?php
        $col1 = 4;
        $col2 = 4;
        $col3 = 4;
        if (empty($widgets['panel_2']) || !has_active_widget($widgets['panel_2'], $active_widgets)) {
            $col2 = $col2 + $col1;
        }

        if (empty($widgets['panel_3']) || !has_active_widget($widgets['panel_3'], $active_widgets)) {
            $col2 = $col2 + $col3;
        }
        ?>
        <div class="container<?php echo (!isset($container_top)) ? ' container_top' : ''; ?>">
            <!-- Features -->
            <div class="row">
                <?php
                echo Pf::shortcode()->exec("{pf:announcement}");
                if (!empty($widgets['panel_2']) && has_active_widget($widgets['panel_2'], $active_widgets)) { ?>
                    <div class="col-sm-<?php echo $col1; ?> col-md-<?php echo $col1 - 1; ?>">
                        <?php load_widgets((is_array($widgets['panel_2'])) ? $widgets['panel_2'] : array(), $setting_data, $active_widgets); ?>
                    </div>
                <?php } ?>
                <div class="col-sm-<?php echo $col2; ?> col-md-<?php echo $col2 + 1; ?>">
                    <?php echo (!empty($rs['page_content'])) ? $rs['page_content'] : ''; ?>
                </div>
                <?php if (!empty($widgets['panel_3']) && has_active_widget($widgets['panel_3'], $active_widgets)) { ?>
                    <div class="col-sm-<?php echo $col3; ?> col-md-<?php echo $col3 - 1; ?>">
                        <?php load_widgets((is_array($widgets['panel_3'])) ? $widgets['panel_3'] : array(), $setting_data, $active_widgets); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php if (!empty($widgets['panel_4']) && has_active_widget($widgets['panel_4'], $active_widgets)) { ?>
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <?php load_widgets((is_array($widgets['panel_4'])) ? $widgets['panel_4'] : array(), $setting_data, $active_widgets); ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div> <!-- / wrapper -->
    <?php
     if(isset($rs['page_type']) && $rs['page_type'] == 0):
        $widgets_footer_uses = array();
        foreach ($widgets_footer as $k => $item) {
            if (!empty($item) && has_active_widget($item, $active_widgets)) {
                $widgets_footer_uses[$k] = $item;
                unset($widgets_footer[$k]);
            }
        }
        ?>
        <div class="footer">
        <?php
        if (!empty($widgets_footer_uses)):
            ?>
                <div class="container">
                    <div class="row multi-columns-row">
                        <?php
                        $col_width = 12 / count($widgets_footer_uses);
                        foreach ($widgets_footer_uses as $item):
                            ?>
                            <div class="col-xs-12 col-sm-6 col-md-<?php echo $col_width; ?>">
                                <?php load_widgets((is_array($item)) ? $item : array(), $setting_footer, $active_widgets); ?>
                            </div>
                        <?php
                        endforeach;
                        ?>
                    </div>
                </div>
        <?php endif; ?>
        </div><!--end .footer-->
        <?php if(isset($aphrodite_options['bottom_content']) && $aphrodite_options['bottom_content'] != ''): ?>
        <div class="copyright">
            <div class="container bottom-content" id="bottom-content">
                <?php echo $aphrodite_options['bottom_content']; ?>
            </div>
        </div>
        <?php endif; ?>
    <?php endif; ?>
    <?php echo get_configuration('google_analytics'); ?>
        
    <!-- include javascript (do not remove this line) -->
    <script>
        $(document).ready(function() {
            $('#navbar-collapse a').click(function(){
                var li_parent   =   $(this).parent();
                var liclass       =   li_parent.attr('class');
                if(liclass=='dropdown open') {window.location  =   $(this).attr('href');}
            });
            $('.hover-dropdown').dropdownHover().dropdown();
            $("#user-bar a, #sign-in a, #sign-up a").tooltip();
            var self = $("#navbar-collapse .dropdown .sub").find(".active-color");
            $("#navbar-collapse>ul>li").each(function(){
                var obj = $(this).find(".active-color");
                if(typeof obj.html() !='undefined'){
                    $(this).attr("class","dropdown active-color");
                    obj.attr("class","");
                    return false;
                }
            });
        });
    </script>
</body>
</html>
